<?php

// Image Reflection Generator Addon
// Version v1.2
// Created by: Jay Williams (dview.us)


function generateReflection($settings_only=false){
global $filnamn;
global $oldfilename;



/********************
ADDON SETTINGS:    */

$path 				= '../images/';
$prefix 			= 'reflect_';

$height 			= 150;
$quality 			= 75;	/* 0 .. 100 */
$mirrorSize 		= 1.35;	/* 1 .. 2 */
$startAlpha 		= 95;	/* 0 .. 127 */

$bgColor['red'] 	= 255;	/* 0 .. 255 */
$bgColor['green'] 	= 255;	/* 0 .. 255 */
$bgColor['blue'] 	= 255;	/* 0 .. 255 */

/********************/








// Only edit the below text if you are familiar with PHP //


if($settings_only == true){
	
	$settings['path'] = $path;
	$settings['path_relative'] = substr($path,3);
	$settings['prefix'] = $prefix;
	$settings['height'] = $height;
	$settings['quality'] = $quality;
	$settings['bgColor']['red'] = $bgColor['red'];
	$settings['bgColor']['green'] = $bgColor['green'];
	$settings['bgColor']['blue'] = $bgColor['blue'];
	
	return $settings;
	
}

if(isset($filnamn))
$file = $filnamn;
else
$file = $oldfilename;

// If no file specfied, return false
if($file == null or $file == '')
return false;

if(file_exists($path . $file)){

	if(file_exists($path. $prefix. $file)){
		unlink($path. $prefix. $file);
	}

$mirrorSize = max( 1, min($mirrorSize, 2) );
$startAlpha = max( 0, min($startAlpha, 127) );

// Load the source file
$imgSrc = imagecreatefromjpeg( $path . $file );

// Create the reflect portion
$imgRfl = ImageCreateTrueColor( ImagesX( $imgSrc ), $height );

// Background Color:
ImageFill( $imgRfl, 0,0, ImageColorAllocate( $imgRfl, $bgColor['red'],$bgColor['green'],$bgColor['blue'] ) );

$offset = ImagesY( $imgSrc ) - ImagesY( $imgRfl );


// In this loop we flip the source image and apply a fade out

for ($y = 0; $y < ImagesY( $imgRfl ); $y++)
{
    ImageCopy( $imgRfl, $imgSrc, 0,$y, 0,ImagesY( $imgSrc )-$y-1, ImagesX( $imgRfl ), 1 );
    $alpha = floor( ($y*(127-$startAlpha)) / ImagesY( $imgRfl ) );
    $color = ImageColorAllocateAlpha( $imgRfl, $bgColor['red'],$bgColor['green'],$bgColor['blue'], 127-$startAlpha-$alpha );
    ImageFilledRectangle( $imgRfl, 0, $y, ImagesX( $imgRfl )-1, $y+1, $color );
}

 

// Create the image buffer which will be outputted

$imgDst = ImageCreateTrueColor( ImagesX( $imgSrc ), $height );

ImageAlphaBlending($imgDst, false);

// Create Image File
ImageCopy( $imgDst, $imgRfl, 0, 0, 0, 0, ImagesX( $imgRfl ), $height );


ImageDestroy( $imgSrc );

ImageDestroy( $imgRfl );

 

// Output the image

imagejpeg( $imgDst,$path . $prefix. $file,$quality);


ImageDestroy( $imgDst );

#echo "Generated Image reflection. ";

}


}
$admin_reflect_settings = generateReflection(true);
// Same info as non admin addons
$addon_name = "Image Reflection Generator";
$addon_description = "This addon generates reflection images and stores them like this: ".$admin_reflect_settings['path_relative'].$admin_reflect_settings['prefix']."&lt;IMAGE_NAME&gt;.jpg<br><br>
You can add the following code to your image template below the image display to see the reflection:<br><blockquote>
&lt;br /&gt; &lt;img src=&quot;&lt;IMAGE_REFLECTION_PATH&gt;&quot; alt=&quot;&quot; width=&quot;&lt;IMAGE_WIDTH&gt;&quot; height=&quot;&lt;IMAGE_REFLECTION_HEIGHT&gt;&quot; border=&quot;0&quot; /&gt;</blockquote>
<br><a name=\"regenerate_imgages\"></a>
If you just installed this addon or you have recently changed some settings, you will want to regenerate all of the reflection images.
<form method='post' action='index.php?view=addons#regenerate_imgages'>
<input type='hidden' name='reflection_regenerate' value='1' />
<input type='submit' value='Regenerate Reflection Images' />
</form>
";
$addon_version = "1.2";

// Regenerate Images //

	// If on addons page, and the regenerate images button is pressed
	if(isset($_GET['view']) and $_GET['view'] == 'addons' and isset($_POST['reflection_regenerate']) and $_POST['reflection_regenerate'] == '1'){
			
		if(!is_dir($admin_reflect_settings['path'])){
			$addon_description .= "<p><strong>Error!</strong><br>Specfied path (<em>".$admin_reflect_settings['path']."</em>) does not exist!</p>";
		}elseif(!is_writable($admin_reflect_settings['path'])){
			$addon_description .= "<p><strong>Error!</strong><br>Can't save images to specified path. (<em>".$admin_reflect_settings['path']."</em>)<br>Please check the folder permissions.</p>";
		}else{
		
		if ($handle = @opendir($admin_reflect_settings['path'])) {
		   while (false !== ($file = readdir($handle))) {
		       if ($file != "." && $file != ".." && strtolower(substr($file, -3)) == 'jpg' && substr($file, 0, 8) != 'reflect_' && substr($file, 0, strlen($admin_reflect_settings['prefix'])) != $admin_reflect_settings['prefix']) {
				$image_list[] = $file;
				}
			}
		}
				
		$total_count = 0;
		if(is_array($image_list)){
			$addon_description .= "<p><strong>Regenerating Images!</strong><br>";
				while(count($image_list) > $total_count){
					$filnamn = $image_list[$total_count];
					generateReflection();
					$total_count++;
				}
			$addon_description .= "Regenerated <strong>$total_count</strong> image(s)</p>";
		}
	}
	} // End Regenerate

$addon_description .= "\r\n<br>Reflection Background Color:<div style=\"background-color: rgb(".$admin_reflect_settings['bgColor']['red'].",".$admin_reflect_settings['bgColor']['green'].",".$admin_reflect_settings['bgColor']['blue']."); width: 100px; text-align: center;\">".$admin_reflect_settings['bgColor']['red'].",".$admin_reflect_settings['bgColor']['green'].",".$admin_reflect_settings['bgColor']['blue']."</div>\r\n";

$addon_description .= "\r\n<br><em>Various settings such as height, background color, and prefix can be set by editing the file, 'admin_reflect.php', located in the addons folder.</em>";

$addon_description .= "<br><br>\r\nAddon created by Jay Williams (<a href=\"http://divew.us/\">dview.us</a>)";


#$tpl = ereg_replace("<IMAGE_REFLECTION_HEIGHT>",$admin_reflect_settings['height'],$tpl); 



$tpl = ereg_replace("<IMAGE_REFLECTION_PATH>",$admin_reflect_settings['path_relative'].$admin_reflect_settings['prefix'].@$image_name,$tpl); 
$tpl = ereg_replace("<IMAGE_REFLECTION_HEIGHT>",strval($admin_reflect_settings['height']),$tpl); 
add_admin_functions('generateReflection','image_uploaded','','');

// added a workspace in the images_edit.php file called "image_re_uploaded"
add_admin_functions('generateReflection','image_re_uploaded','','');

?>